<?php
/**
 * SubscriberStateChangesApi
 * PHP version 7.4
 *
 * @category Class
 * @package  HubSpot\Client\Marketing\Events
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Marketing Events
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: v3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 7.3.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace HubSpot\Client\Marketing\Events\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use HubSpot\Client\Marketing\Events\ApiException;
use HubSpot\Client\Marketing\Events\Configuration;
use HubSpot\Client\Marketing\Events\HeaderSelector;
use HubSpot\Client\Marketing\Events\ObjectSerializer;

/**
 * SubscriberStateChangesApi Class Doc Comment
 *
 * @category Class
 * @package  HubSpot\Client\Marketing\Events
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class SubscriberStateChangesApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'upsertByContactEmail' => [
            'application/json',
        ],
        'upsertByContactId' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation upsertByContactEmail
     *
     * Record a subscriber state by contact email
     *
     * @param  string $external_event_id The ID of the marketing event (required)
     * @param  string $subscriber_state The new subscriber state for the HubSpot contacts and the specified marketing event. For example: &#39;register&#39;, &#39;attend&#39; or &#39;cancel&#39;. (required)
     * @param  string $external_account_id The account ID associated with the marketing event (required)
     * @param  \HubSpot\Client\Marketing\Events\Model\BatchInputMarketingEventEmailSubscriber $batch_input_marketing_event_email_subscriber batch_input_marketing_event_email_subscriber (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['upsertByContactEmail'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Marketing\Events\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Marketing\Events\Model\Error
     */
    public function upsertByContactEmail($external_event_id, $subscriber_state, $external_account_id, $batch_input_marketing_event_email_subscriber, string $contentType = self::contentTypes['upsertByContactEmail'][0])
    {
        list($response) = $this->upsertByContactEmailWithHttpInfo($external_event_id, $subscriber_state, $external_account_id, $batch_input_marketing_event_email_subscriber, $contentType);
        return $response;
    }

    /**
     * Operation upsertByContactEmailWithHttpInfo
     *
     * Record a subscriber state by contact email
     *
     * @param  string $external_event_id The ID of the marketing event (required)
     * @param  string $subscriber_state The new subscriber state for the HubSpot contacts and the specified marketing event. For example: &#39;register&#39;, &#39;attend&#39; or &#39;cancel&#39;. (required)
     * @param  string $external_account_id The account ID associated with the marketing event (required)
     * @param  \HubSpot\Client\Marketing\Events\Model\BatchInputMarketingEventEmailSubscriber $batch_input_marketing_event_email_subscriber (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['upsertByContactEmail'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Marketing\Events\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Marketing\Events\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function upsertByContactEmailWithHttpInfo($external_event_id, $subscriber_state, $external_account_id, $batch_input_marketing_event_email_subscriber, string $contentType = self::contentTypes['upsertByContactEmail'][0])
    {
        $request = $this->upsertByContactEmailRequest($external_event_id, $subscriber_state, $external_account_id, $batch_input_marketing_event_email_subscriber, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                default:
                    if ('\HubSpot\Client\Marketing\Events\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Marketing\Events\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Marketing\Events\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Marketing\Events\Model\Error';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Marketing\Events\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation upsertByContactEmailAsync
     *
     * Record a subscriber state by contact email
     *
     * @param  string $external_event_id The ID of the marketing event (required)
     * @param  string $subscriber_state The new subscriber state for the HubSpot contacts and the specified marketing event. For example: &#39;register&#39;, &#39;attend&#39; or &#39;cancel&#39;. (required)
     * @param  string $external_account_id The account ID associated with the marketing event (required)
     * @param  \HubSpot\Client\Marketing\Events\Model\BatchInputMarketingEventEmailSubscriber $batch_input_marketing_event_email_subscriber (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['upsertByContactEmail'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function upsertByContactEmailAsync($external_event_id, $subscriber_state, $external_account_id, $batch_input_marketing_event_email_subscriber, string $contentType = self::contentTypes['upsertByContactEmail'][0])
    {
        return $this->upsertByContactEmailAsyncWithHttpInfo($external_event_id, $subscriber_state, $external_account_id, $batch_input_marketing_event_email_subscriber, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation upsertByContactEmailAsyncWithHttpInfo
     *
     * Record a subscriber state by contact email
     *
     * @param  string $external_event_id The ID of the marketing event (required)
     * @param  string $subscriber_state The new subscriber state for the HubSpot contacts and the specified marketing event. For example: &#39;register&#39;, &#39;attend&#39; or &#39;cancel&#39;. (required)
     * @param  string $external_account_id The account ID associated with the marketing event (required)
     * @param  \HubSpot\Client\Marketing\Events\Model\BatchInputMarketingEventEmailSubscriber $batch_input_marketing_event_email_subscriber (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['upsertByContactEmail'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function upsertByContactEmailAsyncWithHttpInfo($external_event_id, $subscriber_state, $external_account_id, $batch_input_marketing_event_email_subscriber, string $contentType = self::contentTypes['upsertByContactEmail'][0])
    {
        $returnType = '\HubSpot\Client\Marketing\Events\Model\Error';
        $request = $this->upsertByContactEmailRequest($external_event_id, $subscriber_state, $external_account_id, $batch_input_marketing_event_email_subscriber, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'upsertByContactEmail'
     *
     * @param  string $external_event_id The ID of the marketing event (required)
     * @param  string $subscriber_state The new subscriber state for the HubSpot contacts and the specified marketing event. For example: &#39;register&#39;, &#39;attend&#39; or &#39;cancel&#39;. (required)
     * @param  string $external_account_id The account ID associated with the marketing event (required)
     * @param  \HubSpot\Client\Marketing\Events\Model\BatchInputMarketingEventEmailSubscriber $batch_input_marketing_event_email_subscriber (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['upsertByContactEmail'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function upsertByContactEmailRequest($external_event_id, $subscriber_state, $external_account_id, $batch_input_marketing_event_email_subscriber, string $contentType = self::contentTypes['upsertByContactEmail'][0])
    {

        // verify the required parameter 'external_event_id' is set
        if ($external_event_id === null || (is_array($external_event_id) && count($external_event_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $external_event_id when calling upsertByContactEmail'
            );
        }

        // verify the required parameter 'subscriber_state' is set
        if ($subscriber_state === null || (is_array($subscriber_state) && count($subscriber_state) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $subscriber_state when calling upsertByContactEmail'
            );
        }

        // verify the required parameter 'external_account_id' is set
        if ($external_account_id === null || (is_array($external_account_id) && count($external_account_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $external_account_id when calling upsertByContactEmail'
            );
        }

        // verify the required parameter 'batch_input_marketing_event_email_subscriber' is set
        if ($batch_input_marketing_event_email_subscriber === null || (is_array($batch_input_marketing_event_email_subscriber) && count($batch_input_marketing_event_email_subscriber) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $batch_input_marketing_event_email_subscriber when calling upsertByContactEmail'
            );
        }


        $resourcePath = '/marketing/v3/marketing-events/events/{externalEventId}/{subscriberState}/email-upsert';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $external_account_id,
            'externalAccountId', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);


        // path params
        if ($external_event_id !== null) {
            $resourcePath = str_replace(
                '{' . 'externalEventId' . '}',
                ObjectSerializer::toPathValue($external_event_id),
                $resourcePath
            );
        }
        // path params
        if ($subscriber_state !== null) {
            $resourcePath = str_replace(
                '{' . 'subscriberState' . '}',
                ObjectSerializer::toPathValue($subscriber_state),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($batch_input_marketing_event_email_subscriber)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($batch_input_marketing_event_email_subscriber));
            } else {
                $httpBody = $batch_input_marketing_event_email_subscriber;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation upsertByContactId
     *
     * Record a subscriber state by contact ID
     *
     * @param  string $external_event_id The ID of the marketing event (required)
     * @param  string $subscriber_state The new subscriber state for the HubSpot contacts and the specified marketing event. For example: &#39;register&#39;, &#39;attend&#39; or &#39;cancel&#39;. (required)
     * @param  string $external_account_id The account ID associated with the marketing event (required)
     * @param  \HubSpot\Client\Marketing\Events\Model\BatchInputMarketingEventSubscriber $batch_input_marketing_event_subscriber batch_input_marketing_event_subscriber (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['upsertByContactId'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Marketing\Events\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Marketing\Events\Model\Error
     */
    public function upsertByContactId($external_event_id, $subscriber_state, $external_account_id, $batch_input_marketing_event_subscriber, string $contentType = self::contentTypes['upsertByContactId'][0])
    {
        list($response) = $this->upsertByContactIdWithHttpInfo($external_event_id, $subscriber_state, $external_account_id, $batch_input_marketing_event_subscriber, $contentType);
        return $response;
    }

    /**
     * Operation upsertByContactIdWithHttpInfo
     *
     * Record a subscriber state by contact ID
     *
     * @param  string $external_event_id The ID of the marketing event (required)
     * @param  string $subscriber_state The new subscriber state for the HubSpot contacts and the specified marketing event. For example: &#39;register&#39;, &#39;attend&#39; or &#39;cancel&#39;. (required)
     * @param  string $external_account_id The account ID associated with the marketing event (required)
     * @param  \HubSpot\Client\Marketing\Events\Model\BatchInputMarketingEventSubscriber $batch_input_marketing_event_subscriber (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['upsertByContactId'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Marketing\Events\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Marketing\Events\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function upsertByContactIdWithHttpInfo($external_event_id, $subscriber_state, $external_account_id, $batch_input_marketing_event_subscriber, string $contentType = self::contentTypes['upsertByContactId'][0])
    {
        $request = $this->upsertByContactIdRequest($external_event_id, $subscriber_state, $external_account_id, $batch_input_marketing_event_subscriber, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                default:
                    if ('\HubSpot\Client\Marketing\Events\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Marketing\Events\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Marketing\Events\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Marketing\Events\Model\Error';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Marketing\Events\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation upsertByContactIdAsync
     *
     * Record a subscriber state by contact ID
     *
     * @param  string $external_event_id The ID of the marketing event (required)
     * @param  string $subscriber_state The new subscriber state for the HubSpot contacts and the specified marketing event. For example: &#39;register&#39;, &#39;attend&#39; or &#39;cancel&#39;. (required)
     * @param  string $external_account_id The account ID associated with the marketing event (required)
     * @param  \HubSpot\Client\Marketing\Events\Model\BatchInputMarketingEventSubscriber $batch_input_marketing_event_subscriber (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['upsertByContactId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function upsertByContactIdAsync($external_event_id, $subscriber_state, $external_account_id, $batch_input_marketing_event_subscriber, string $contentType = self::contentTypes['upsertByContactId'][0])
    {
        return $this->upsertByContactIdAsyncWithHttpInfo($external_event_id, $subscriber_state, $external_account_id, $batch_input_marketing_event_subscriber, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation upsertByContactIdAsyncWithHttpInfo
     *
     * Record a subscriber state by contact ID
     *
     * @param  string $external_event_id The ID of the marketing event (required)
     * @param  string $subscriber_state The new subscriber state for the HubSpot contacts and the specified marketing event. For example: &#39;register&#39;, &#39;attend&#39; or &#39;cancel&#39;. (required)
     * @param  string $external_account_id The account ID associated with the marketing event (required)
     * @param  \HubSpot\Client\Marketing\Events\Model\BatchInputMarketingEventSubscriber $batch_input_marketing_event_subscriber (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['upsertByContactId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function upsertByContactIdAsyncWithHttpInfo($external_event_id, $subscriber_state, $external_account_id, $batch_input_marketing_event_subscriber, string $contentType = self::contentTypes['upsertByContactId'][0])
    {
        $returnType = '\HubSpot\Client\Marketing\Events\Model\Error';
        $request = $this->upsertByContactIdRequest($external_event_id, $subscriber_state, $external_account_id, $batch_input_marketing_event_subscriber, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'upsertByContactId'
     *
     * @param  string $external_event_id The ID of the marketing event (required)
     * @param  string $subscriber_state The new subscriber state for the HubSpot contacts and the specified marketing event. For example: &#39;register&#39;, &#39;attend&#39; or &#39;cancel&#39;. (required)
     * @param  string $external_account_id The account ID associated with the marketing event (required)
     * @param  \HubSpot\Client\Marketing\Events\Model\BatchInputMarketingEventSubscriber $batch_input_marketing_event_subscriber (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['upsertByContactId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function upsertByContactIdRequest($external_event_id, $subscriber_state, $external_account_id, $batch_input_marketing_event_subscriber, string $contentType = self::contentTypes['upsertByContactId'][0])
    {

        // verify the required parameter 'external_event_id' is set
        if ($external_event_id === null || (is_array($external_event_id) && count($external_event_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $external_event_id when calling upsertByContactId'
            );
        }

        // verify the required parameter 'subscriber_state' is set
        if ($subscriber_state === null || (is_array($subscriber_state) && count($subscriber_state) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $subscriber_state when calling upsertByContactId'
            );
        }

        // verify the required parameter 'external_account_id' is set
        if ($external_account_id === null || (is_array($external_account_id) && count($external_account_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $external_account_id when calling upsertByContactId'
            );
        }

        // verify the required parameter 'batch_input_marketing_event_subscriber' is set
        if ($batch_input_marketing_event_subscriber === null || (is_array($batch_input_marketing_event_subscriber) && count($batch_input_marketing_event_subscriber) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $batch_input_marketing_event_subscriber when calling upsertByContactId'
            );
        }


        $resourcePath = '/marketing/v3/marketing-events/events/{externalEventId}/{subscriberState}/upsert';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $external_account_id,
            'externalAccountId', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);


        // path params
        if ($external_event_id !== null) {
            $resourcePath = str_replace(
                '{' . 'externalEventId' . '}',
                ObjectSerializer::toPathValue($external_event_id),
                $resourcePath
            );
        }
        // path params
        if ($subscriber_state !== null) {
            $resourcePath = str_replace(
                '{' . 'subscriberState' . '}',
                ObjectSerializer::toPathValue($subscriber_state),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($batch_input_marketing_event_subscriber)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($batch_input_marketing_event_subscriber));
            } else {
                $httpBody = $batch_input_marketing_event_subscriber;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
