<?php
/**
 * StatisticsApi
 * PHP version 7.4
 *
 * @category Class
 * @package  HubSpot\Client\Marketing\Emails
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Marketing Emails
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: v3
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.12.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace HubSpot\Client\Marketing\Emails\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use HubSpot\Client\Marketing\Emails\ApiException;
use HubSpot\Client\Marketing\Emails\Configuration;
use HubSpot\Client\Marketing\Emails\HeaderSelector;
use HubSpot\Client\Marketing\Emails\ObjectSerializer;

/**
 * StatisticsApi Class Doc Comment
 *
 * @category Class
 * @package  HubSpot\Client\Marketing\Emails
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class StatisticsApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'getEmailsList' => [
            'application/json',
        ],
        'getHistogram' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation getEmailsList
     *
     * Get aggregated statistics.
     *
     * @param  string|null $start_timestamp The start timestamp of the time span, in ISO8601 representation. (optional)
     * @param  string|null $end_timestamp The end timestamp of the time span, in ISO8601 representation. (optional)
     * @param  int[]|null $email_ids Filter by email IDs. Only include statistics of emails with these IDs. (optional)
     * @param  string|null $property Specifies which email properties should be returned. All properties will be returned by default. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getEmailsList'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Marketing\Emails\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Marketing\Emails\Model\AggregateEmailStatistics|\HubSpot\Client\Marketing\Emails\Model\Error
     */
    public function getEmailsList($start_timestamp = null, $end_timestamp = null, $email_ids = null, $property = null, string $contentType = self::contentTypes['getEmailsList'][0])
    {
        list($response) = $this->getEmailsListWithHttpInfo($start_timestamp, $end_timestamp, $email_ids, $property, $contentType);
        return $response;
    }

    /**
     * Operation getEmailsListWithHttpInfo
     *
     * Get aggregated statistics.
     *
     * @param  string|null $start_timestamp The start timestamp of the time span, in ISO8601 representation. (optional)
     * @param  string|null $end_timestamp The end timestamp of the time span, in ISO8601 representation. (optional)
     * @param  int[]|null $email_ids Filter by email IDs. Only include statistics of emails with these IDs. (optional)
     * @param  string|null $property Specifies which email properties should be returned. All properties will be returned by default. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getEmailsList'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Marketing\Emails\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Marketing\Emails\Model\AggregateEmailStatistics|\HubSpot\Client\Marketing\Emails\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEmailsListWithHttpInfo($start_timestamp = null, $end_timestamp = null, $email_ids = null, $property = null, string $contentType = self::contentTypes['getEmailsList'][0])
    {
        $request = $this->getEmailsListRequest($start_timestamp, $end_timestamp, $email_ids, $property, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Marketing\Emails\Model\AggregateEmailStatistics' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Marketing\Emails\Model\AggregateEmailStatistics' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Marketing\Emails\Model\AggregateEmailStatistics', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Marketing\Emails\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Marketing\Emails\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Marketing\Emails\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\HubSpot\Client\Marketing\Emails\Model\AggregateEmailStatistics';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Marketing\Emails\Model\AggregateEmailStatistics',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Marketing\Emails\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getEmailsListAsync
     *
     * Get aggregated statistics.
     *
     * @param  string|null $start_timestamp The start timestamp of the time span, in ISO8601 representation. (optional)
     * @param  string|null $end_timestamp The end timestamp of the time span, in ISO8601 representation. (optional)
     * @param  int[]|null $email_ids Filter by email IDs. Only include statistics of emails with these IDs. (optional)
     * @param  string|null $property Specifies which email properties should be returned. All properties will be returned by default. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getEmailsList'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEmailsListAsync($start_timestamp = null, $end_timestamp = null, $email_ids = null, $property = null, string $contentType = self::contentTypes['getEmailsList'][0])
    {
        return $this->getEmailsListAsyncWithHttpInfo($start_timestamp, $end_timestamp, $email_ids, $property, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getEmailsListAsyncWithHttpInfo
     *
     * Get aggregated statistics.
     *
     * @param  string|null $start_timestamp The start timestamp of the time span, in ISO8601 representation. (optional)
     * @param  string|null $end_timestamp The end timestamp of the time span, in ISO8601 representation. (optional)
     * @param  int[]|null $email_ids Filter by email IDs. Only include statistics of emails with these IDs. (optional)
     * @param  string|null $property Specifies which email properties should be returned. All properties will be returned by default. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getEmailsList'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEmailsListAsyncWithHttpInfo($start_timestamp = null, $end_timestamp = null, $email_ids = null, $property = null, string $contentType = self::contentTypes['getEmailsList'][0])
    {
        $returnType = '\HubSpot\Client\Marketing\Emails\Model\AggregateEmailStatistics';
        $request = $this->getEmailsListRequest($start_timestamp, $end_timestamp, $email_ids, $property, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getEmailsList'
     *
     * @param  string|null $start_timestamp The start timestamp of the time span, in ISO8601 representation. (optional)
     * @param  string|null $end_timestamp The end timestamp of the time span, in ISO8601 representation. (optional)
     * @param  int[]|null $email_ids Filter by email IDs. Only include statistics of emails with these IDs. (optional)
     * @param  string|null $property Specifies which email properties should be returned. All properties will be returned by default. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getEmailsList'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getEmailsListRequest($start_timestamp = null, $end_timestamp = null, $email_ids = null, $property = null, string $contentType = self::contentTypes['getEmailsList'][0])
    {






        $resourcePath = '/marketing/v3/emails/statistics/list';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $start_timestamp,
            'startTimestamp', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $end_timestamp,
            'endTimestamp', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $email_ids,
            'emailIds', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $property,
            'property', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', '*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getHistogram
     *
     * Get aggregated statistic intervals.
     *
     * @param  string|null $interval The interval to aggregate statistics for. (optional)
     * @param  string|null $start_timestamp The start timestamp of the time span, in ISO8601 representation. (optional)
     * @param  string|null $end_timestamp The end timestamp of the time span, in ISO8601 representation. (optional)
     * @param  int[]|null $email_ids Filter by email IDs. Only include statistics of emails with these IDs. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getHistogram'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Marketing\Emails\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Marketing\Emails\Model\CollectionResponseWithTotalEmailStatisticIntervalNoPaging|\HubSpot\Client\Marketing\Emails\Model\Error
     */
    public function getHistogram($interval = null, $start_timestamp = null, $end_timestamp = null, $email_ids = null, string $contentType = self::contentTypes['getHistogram'][0])
    {
        list($response) = $this->getHistogramWithHttpInfo($interval, $start_timestamp, $end_timestamp, $email_ids, $contentType);
        return $response;
    }

    /**
     * Operation getHistogramWithHttpInfo
     *
     * Get aggregated statistic intervals.
     *
     * @param  string|null $interval The interval to aggregate statistics for. (optional)
     * @param  string|null $start_timestamp The start timestamp of the time span, in ISO8601 representation. (optional)
     * @param  string|null $end_timestamp The end timestamp of the time span, in ISO8601 representation. (optional)
     * @param  int[]|null $email_ids Filter by email IDs. Only include statistics of emails with these IDs. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getHistogram'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Marketing\Emails\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Marketing\Emails\Model\CollectionResponseWithTotalEmailStatisticIntervalNoPaging|\HubSpot\Client\Marketing\Emails\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getHistogramWithHttpInfo($interval = null, $start_timestamp = null, $end_timestamp = null, $email_ids = null, string $contentType = self::contentTypes['getHistogram'][0])
    {
        $request = $this->getHistogramRequest($interval, $start_timestamp, $end_timestamp, $email_ids, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Marketing\Emails\Model\CollectionResponseWithTotalEmailStatisticIntervalNoPaging' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Marketing\Emails\Model\CollectionResponseWithTotalEmailStatisticIntervalNoPaging' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Marketing\Emails\Model\CollectionResponseWithTotalEmailStatisticIntervalNoPaging', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Marketing\Emails\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Marketing\Emails\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Marketing\Emails\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            $returnType = '\HubSpot\Client\Marketing\Emails\Model\CollectionResponseWithTotalEmailStatisticIntervalNoPaging';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Marketing\Emails\Model\CollectionResponseWithTotalEmailStatisticIntervalNoPaging',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Marketing\Emails\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getHistogramAsync
     *
     * Get aggregated statistic intervals.
     *
     * @param  string|null $interval The interval to aggregate statistics for. (optional)
     * @param  string|null $start_timestamp The start timestamp of the time span, in ISO8601 representation. (optional)
     * @param  string|null $end_timestamp The end timestamp of the time span, in ISO8601 representation. (optional)
     * @param  int[]|null $email_ids Filter by email IDs. Only include statistics of emails with these IDs. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getHistogram'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getHistogramAsync($interval = null, $start_timestamp = null, $end_timestamp = null, $email_ids = null, string $contentType = self::contentTypes['getHistogram'][0])
    {
        return $this->getHistogramAsyncWithHttpInfo($interval, $start_timestamp, $end_timestamp, $email_ids, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getHistogramAsyncWithHttpInfo
     *
     * Get aggregated statistic intervals.
     *
     * @param  string|null $interval The interval to aggregate statistics for. (optional)
     * @param  string|null $start_timestamp The start timestamp of the time span, in ISO8601 representation. (optional)
     * @param  string|null $end_timestamp The end timestamp of the time span, in ISO8601 representation. (optional)
     * @param  int[]|null $email_ids Filter by email IDs. Only include statistics of emails with these IDs. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getHistogram'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getHistogramAsyncWithHttpInfo($interval = null, $start_timestamp = null, $end_timestamp = null, $email_ids = null, string $contentType = self::contentTypes['getHistogram'][0])
    {
        $returnType = '\HubSpot\Client\Marketing\Emails\Model\CollectionResponseWithTotalEmailStatisticIntervalNoPaging';
        $request = $this->getHistogramRequest($interval, $start_timestamp, $end_timestamp, $email_ids, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getHistogram'
     *
     * @param  string|null $interval The interval to aggregate statistics for. (optional)
     * @param  string|null $start_timestamp The start timestamp of the time span, in ISO8601 representation. (optional)
     * @param  string|null $end_timestamp The end timestamp of the time span, in ISO8601 representation. (optional)
     * @param  int[]|null $email_ids Filter by email IDs. Only include statistics of emails with these IDs. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getHistogram'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getHistogramRequest($interval = null, $start_timestamp = null, $end_timestamp = null, $email_ids = null, string $contentType = self::contentTypes['getHistogram'][0])
    {






        $resourcePath = '/marketing/v3/emails/statistics/histogram';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $interval,
            'interval', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $start_timestamp,
            'startTimestamp', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $end_timestamp,
            'endTimestamp', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $email_ids,
            'emailIds', // param base name
            'array', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', '*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
