<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\WorkspaceEvents;

class HTTPAuthSecurityScheme extends \Google\Model
{
  /**
   * A hint to the client to identify how the bearer token is formatted. Bearer
   * tokens are usually generated by an authorization server, so this
   * information is primarily for documentation purposes.
   *
   * @var string
   */
  public $bearerFormat;
  /**
   * Description of this security scheme.
   *
   * @var string
   */
  public $description;
  /**
   * The name of the HTTP Authentication scheme to be used in the Authorization
   * header as defined in RFC7235. The values used SHOULD be registered in the
   * IANA Authentication Scheme registry. The value is case-insensitive, as
   * defined in RFC7235.
   *
   * @var string
   */
  public $scheme;

  /**
   * A hint to the client to identify how the bearer token is formatted. Bearer
   * tokens are usually generated by an authorization server, so this
   * information is primarily for documentation purposes.
   *
   * @param string $bearerFormat
   */
  public function setBearerFormat($bearerFormat)
  {
    $this->bearerFormat = $bearerFormat;
  }
  /**
   * @return string
   */
  public function getBearerFormat()
  {
    return $this->bearerFormat;
  }
  /**
   * Description of this security scheme.
   *
   * @param string $description
   */
  public function setDescription($description)
  {
    $this->description = $description;
  }
  /**
   * @return string
   */
  public function getDescription()
  {
    return $this->description;
  }
  /**
   * The name of the HTTP Authentication scheme to be used in the Authorization
   * header as defined in RFC7235. The values used SHOULD be registered in the
   * IANA Authentication Scheme registry. The value is case-insensitive, as
   * defined in RFC7235.
   *
   * @param string $scheme
   */
  public function setScheme($scheme)
  {
    $this->scheme = $scheme;
  }
  /**
   * @return string
   */
  public function getScheme()
  {
    return $this->scheme;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(HTTPAuthSecurityScheme::class, 'Google_Service_WorkspaceEvents_HTTPAuthSecurityScheme');
