<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\ShoppingContent;

class RegionGeoTargetArea extends \Google\Collection
{
  protected $collection_key = 'geotargetCriteriaIds';
  /**
   * Required. A non-empty list of [location
   * IDs](https://developers.google.com/adwords/api/docs/appendix/geotargeting).
   * They must all be of the same location type (e.g., state).
   *
   * @var string[]
   */
  public $geotargetCriteriaIds;

  /**
   * Required. A non-empty list of [location
   * IDs](https://developers.google.com/adwords/api/docs/appendix/geotargeting).
   * They must all be of the same location type (e.g., state).
   *
   * @param string[] $geotargetCriteriaIds
   */
  public function setGeotargetCriteriaIds($geotargetCriteriaIds)
  {
    $this->geotargetCriteriaIds = $geotargetCriteriaIds;
  }
  /**
   * @return string[]
   */
  public function getGeotargetCriteriaIds()
  {
    return $this->geotargetCriteriaIds;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(RegionGeoTargetArea::class, 'Google_Service_ShoppingContent_RegionGeoTargetArea');
