<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\DoubleClickBidManager;

class FilterPair extends \Google\Model
{
  /**
   * The type of value to filter by. Defined by a [Filter](/bid-
   * manager/reference/rest/v2/filters-metrics#filters) value.
   *
   * @var string
   */
  public $type;
  /**
   * The identifying value to filter by, such as a relevant resource ID.
   *
   * @var string
   */
  public $value;

  /**
   * The type of value to filter by. Defined by a [Filter](/bid-
   * manager/reference/rest/v2/filters-metrics#filters) value.
   *
   * @param string $type
   */
  public function setType($type)
  {
    $this->type = $type;
  }
  /**
   * @return string
   */
  public function getType()
  {
    return $this->type;
  }
  /**
   * The identifying value to filter by, such as a relevant resource ID.
   *
   * @param string $value
   */
  public function setValue($value)
  {
    $this->value = $value;
  }
  /**
   * @return string
   */
  public function getValue()
  {
    return $this->value;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(FilterPair::class, 'Google_Service_DoubleClickBidManager_FilterPair');
