@extends('panel.layout.app')

@section('title', __('Team'))

@section('content')
	<!-- Page body -->
	<div class="py-10 row">
		<div class="col-md-5 mx-auto">
			<div class="header d-flex justify-content-center">
				@if ($user && $user?->avatar)
					<img
						src="{{ custom_theme_url($user?->avatar) }}"
						style="width: 150px"
					>
				@endif

				<div class="w-full p-3">
					<p class="fs-2 font-bold">{{ $user?->fullName() }}</p>
					@if ($member->joined_at)
						<p>@lang('Member Since') {{ $member->joined_at->format('M d, Y') }}</p>
					@endif
					<span
						class="badge bg- bg-{{ $member->status == 'waiting' ? 'dark font-weight-medium' : ($member->status == 'active' ? 'success' : 'danger') }}">@lang(strtoupper($member->status))</span>
				</div>
			</div>

			<div class="card">
				<div class="card-body">
					<p class="fs-1 font-bold">@lang('Your Team Plan')</p>
					<x-credit-list
						class="pt-2"
						:team="$team"
						:showLegend="true"
					/>
				</div>
			</div>

			{{--                    <div class="row mb-4 mt-4">--}}
			{{--                        <div class="col-md-6">--}}
			{{--                            <div class="card">--}}
			{{--                                <div class="card-body">--}}
			{{--                                    <label class="font-weight-medium mb-3">--}}
			{{--                                        @lang('Words Generated') <x-info-tooltip text="{{ __('Displays the number of words generated by this team member.') }}" />--}}
			{{--                                    </label>--}}
			{{--                                    <span>{{ $remaining_words }}</span>--}}
			{{--                                </div>--}}
			{{--                            </div>--}}
			{{--                        </div>--}}
			{{--                        <div class="col-md-6">--}}
			{{--                            <div class="card">--}}
			{{--                                <div class="card-body">--}}
			{{--                                    <label class="font-weight-medium mb-3">--}}
			{{--                                        @lang('Images Generated') <x-info-tooltip text="{{ __('Displays the number of images generated by this team member.') }}" />--}}
			{{--                                    </label>--}}
			{{--                                    <span>{{ $remaining_images }}</span>--}}
			{{--                                </div>--}}
			{{--                            </div>--}}
			{{--                        </div>--}}
			{{--                    </div>--}}

			<div
				class="my-4 rounded-xl p-3"
				style="background-color: rgba(157, 107, 221, 0.1);"
			>
				<p class="fs-2 font-weight-medium mb-0 pb-0 font-bold"><span
						class="me-2 rounded pe-2 ps-2 text-white"
						style="background-color: rgba(157, 107, 221, 1)"
					>1</span>@lang('Manage User')</p>
			</div>

			<form
				class="row"
				action="{{ route('dashboard.user.team.member.update', [$team->id, $member->id]) }}"
				method="post"
			>
				@csrf
				<div class="col-md-12">
					<div class="mb-3">
						<label class="form-label">{{ __('Role') }}</label>
						<input
							class="form-control @error('role') is-invalid @enderror"
							id="role"
							type="text"
							name="role"
							value="{{ $member->role }}"
						>
						@error('role')
						<div class="invalid-feedback">
							{{ $message }}
						</div>
						@enderror
					</div>
				</div>
				<div class="col-md-12">
					<div class="mb-4">
						<label class="form-label">{{ __('Status') }}</label>
						<select
							class="form-control @error('role') is-invalid @enderror"
							name="status"
						>
							<option
								value="active"
								{{ $member->status == 'active' ? 'selected' : '' }}
							>
								@lang('Active')</option>
							<option
								value="waiting"
								{{ $member->status == 'waiting' ? 'selected' : '' }}
							>
								@lang('Waiting')</option>
							<option
								value="cancelled"
								{{ $member->status == 'cancelled' ? 'selected' : '' }}
							>
								@lang('Cancelled')</option>
						</select>
						@error('status')
						<div class="invalid-feedback">
							{{ $message }}
						</div>
						@enderror
					</div>
				</div>
				<div class="col-md-12">
					<button
						class="btn btn-primary w-full"
						type="submit"
					>
						@lang('Save Changes')
					</button>
				</div>
			</form>
		</div>
	</div>
@endsection

@push('script')
	<script>
		// @formatter:off
        document.addEventListener("DOMContentLoaded", function() {
            "use strict";

            $('#allow_unlimited_credits').change(function() {

                let checked = $(this).is(':checked');

                if (checked) {
                    $('#credit_limit_custom').addClass('d-none');
                } else {
                    $('#credit_limit_custom').removeClass('d-none');
                }
            })

            const options = {
                series: [{{ (int) $remaining_words }}, {{ (int) $total_words }}],
                labels: [@json(__('Remaining')), @json(__('Used'))],
                colors: ['hsl(var(--accent))', 'hsl(var(--accent)/20%)'],
                chart: {
                    type: 'donut',
                    height: 205,
                },
                legend: {
                    position: 'bottom',
                    fontFamily: 'inherit',
                },
                plotOptions: {
                    pie: {
                        startAngle: -90,
                        endAngle: 90,
                        offsetY: 0,
                        donut: {
                            size: '75%',
                        }
                    },
                },
                grid: {
                    padding: {
                        bottom: -130
                    }
                },
                stroke: {
                    width: 5,
                    colors: 'hsl(var(--background))'
                },
                responsive: [{
                    breakpoint: 480,
                    options: {
                        chart: {
                            width: 280,
                            height: 250
                        },
                    }
                }],
                dataLabels: {
                    enabled: false,
                }
            };
            window.ApexCharts && (new ApexCharts(document.getElementById('chart-credit'), options)).render();
        });
        // @formatter:on
	</script>
@endpush
