<?php

namespace App\Enums\AiInfluencer;

use App\Enums\Traits\EnumTo;

enum BrandEnum: string
{
    use EnumTo;

    case AMAZON = 'amazon';
    case SHOPIFY = 'shopify';
    case ETSY = 'etsy';
    case EBAY = 'ebay';
    case WORDPRESS = 'wordpress';
    case GOOGLE_PLAY = 'google_play';
    case APP_STORE = 'app_store';

    public function label()
    {
        return match ($this) {
            self::AMAZON      => 'Amazon',
            self::SHOPIFY     => 'Shopify',
            self::ETSY        => 'Etsy',
            self::EBAY        => 'Ebay',
            self::WORDPRESS   => 'Wordpress',
            self::GOOGLE_PLAY => 'Google Play',
            self::APP_STORE   => 'App Store',
        };
    }

    public function image()
    {
        return match ($this) {
            self::AMAZON      => '<svg width="21" height="22" viewBox="0 0 21 22" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M12.0562 6.16263C9.77343 6.24701 4.11092 6.8892 4.11092 11.6704C4.11092 16.8033 10.5937 17.0142 12.7125 13.6954C13.0172 14.1736 14.3719 15.4533 14.8359 15.8892L17.4984 13.2642C17.4984 13.2642 15.9844 12.0783 15.9844 10.7892V3.89388C15.9844 2.70795 14.8359 0.0360718 10.7203 0.0360718C6.5953 0.0360718 4.40624 2.6142 4.40624 4.92513L7.85155 5.24388C8.61561 2.92357 10.3922 2.92357 10.3922 2.92357C12.3 2.91888 12.0562 4.32045 12.0562 6.16263ZM12.0562 10.2314C12.0562 13.9814 8.10936 13.4189 8.10936 11.0376C8.10936 8.82514 10.4766 8.37982 12.0562 8.32826V10.2314ZM18.4312 17.8954C18.0703 18.3642 15.15 21.0361 10.2515 21.0361C5.35311 21.0361 1.60311 17.6845 0.454675 16.3017C0.135925 15.9408 0.50155 15.772 0.712487 15.9126C4.14842 17.9986 9.51561 21.4345 18.1734 17.3329C18.525 17.1595 18.7969 17.4267 18.4312 17.8954ZM20.2969 17.9986C19.9922 18.7392 19.5469 19.2548 19.3031 19.4517C19.0453 19.6626 18.8578 19.5783 18.9984 19.2736C19.139 18.9689 19.9031 17.0939 19.5937 16.6954C19.289 16.3064 17.8594 16.4939 17.3437 16.5454C16.8375 16.5923 16.7344 16.6392 16.6875 16.5314C16.5797 16.2642 17.7047 15.8048 18.4453 15.7111C19.1812 15.6267 20.3672 15.6736 20.6015 15.9783C20.775 16.2173 20.6015 17.2486 20.2969 17.9986Z" fill="currentColor"/></svg>',
            self::SHOPIFY     => '<svg width="21" height="25" viewBox="0 0 21 25" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M18.3682 5.41575C18.3607 5.36552 18.3361 5.31941 18.2985 5.28524C18.2609 5.25107 18.2127 5.23094 18.162 5.22825C18.0682 5.22825 16.4182 5.19075 16.4182 5.19075C16.4182 5.19075 15.4057 4.21575 15.0307 3.84075V24.1236L20.9229 22.6611C20.9229 22.6611 18.387 5.52825 18.3682 5.41575ZM13.6995 3.84075C13.6096 3.55703 13.4967 3.28112 13.362 3.01575C12.8698 2.07825 12.1385 1.56732 11.276 1.56732C11.213 1.56513 11.1499 1.57143 11.0885 1.58607C11.0698 1.54857 11.0323 1.52982 11.0135 1.49232C10.6385 1.07982 10.151 0.892317 9.56979 0.911067C8.44479 0.948567 7.31979 1.75482 6.4151 3.19857C5.7776 4.21107 5.2901 5.48607 5.15885 6.4845C3.8651 6.87825 2.9651 7.1595 2.94635 7.17825C2.2901 7.3845 2.27135 7.40325 2.19635 8.022C2.1401 8.49075 0.4151 21.7001 0.4151 21.7001L14.5995 24.1611V3.61575C14.5304 3.61836 14.4616 3.62461 14.3932 3.6345C14.3932 3.6345 14.1307 3.7095 13.6995 3.84075ZM11.1073 4.647C10.3573 4.872 9.53229 5.1345 8.72604 5.37825C8.95104 4.497 9.40104 3.61575 9.92604 3.0345C10.1323 2.82825 10.4135 2.5845 10.7323 2.4345C11.051 3.1095 11.126 4.02825 11.1073 4.647ZM9.56979 1.67982C9.806 1.67313 10.0395 1.73151 10.2448 1.84857C9.94479 1.99857 9.64479 2.24232 9.36354 2.52357C8.65104 3.29232 8.10729 4.49232 7.88229 5.64075C7.20729 5.847 6.53229 6.05325 5.91354 6.24075C6.32135 4.44075 7.84479 1.71732 9.56979 1.67982ZM7.39479 12.0017C7.46979 13.2017 10.6432 13.4642 10.8307 16.3001C10.962 18.5314 9.64948 20.0548 7.75104 20.1673C5.46354 20.3173 4.2026 18.9673 4.2026 18.9673L4.6901 16.9048C4.6901 16.9048 5.94635 17.8611 6.95885 17.7861C7.6151 17.7486 7.85885 17.2048 7.8401 16.8298C7.74635 15.2548 5.15885 15.3486 4.9901 12.7564C4.8401 10.5814 6.2651 8.38294 9.41979 8.17669C10.6385 8.10169 11.2573 8.40169 11.2573 8.40169L10.5448 11.1017C10.5448 11.1017 9.73854 10.7267 8.78229 10.8017C7.39479 10.8954 7.37604 11.7767 7.39479 12.0017ZM11.8573 4.422C11.8573 3.8595 11.7823 3.05325 11.5198 2.37825C12.3823 2.547 12.7948 3.50325 12.9823 4.0845C12.6448 4.17825 12.2698 4.29075 11.8573 4.422Z" fill="currentColor"/></svg>',
            self::ETSY        => '<svg width="19" height="22" viewBox="0 0 19 22" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M18.3334 14.8486C18.249 15.3548 17.6865 20.0048 17.6068 21.0361C12.0802 20.8345 7.299 20.8157 0.333374 21.0361V19.8407C2.46619 19.4236 3.174 19.4657 3.19275 18.1861C3.27712 14.797 3.35681 6.74387 3.19275 3.09231C3.14587 1.75637 2.62556 1.83606 0.333374 1.40481V0.209497C3.79744 0.321997 12.3287 0.612622 17.349 0.0313721C17.1849 1.82668 16.9834 5.96106 16.9834 5.96106H15.8959C15.3756 3.9595 15.0146 1.72356 13.3318 1.72356H6.90994C6.42712 1.72356 6.40369 1.88762 6.40369 2.18293V9.85637C9.12244 9.87981 10.5521 9.73919 10.5521 9.73919C11.949 9.69231 11.8459 9.34075 12.4646 6.67825H13.674C13.4677 11.4314 13.4912 9.57512 13.5896 14.1923H12.3802C11.949 12.3126 11.9537 11.3329 10.5287 11.3095C10.5287 11.3095 9.52087 11.2157 6.40369 11.2157V17.7314C6.40369 18.9501 7.074 19.5267 8.48025 19.5267H12.6615C15.6427 19.5267 15.7834 18.3548 17.2927 14.8486H18.3334Z" fill="currentColor"/></svg>',
            self::EBAY        => '<svg width="31" height="13" viewBox="0 0 31 13" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M28.9063 3.41889L26.3375 8.57045L23.7641 3.41889H22.0063L22.5172 4.38452C21.9781 3.49389 20.8344 3.16577 19.55 3.16577C18.0594 3.16577 16.3672 3.57358 16.1984 5.18608H17.7781C17.8438 4.5392 18.5141 4.1642 19.4188 4.1642C20.6375 4.1642 21.3406 4.6142 21.3406 5.71108V5.87045C20.7453 5.87045 20.0281 5.87514 19.3859 5.8892C17.3984 5.93139 16.1235 6.35795 15.7906 7.5017C15.8375 7.25795 15.861 7.00483 15.861 6.74233C15.861 4.30014 14 3.17045 12.3266 3.17045C11.3281 3.17045 10.3109 3.42826 9.57501 4.30483V0.526703H8.07032V8.47201C8.07032 8.95483 8.0422 9.54545 8.01876 10.0236H9.49532C9.52814 9.72826 9.54689 9.41889 9.54689 9.10952C10.1844 9.88764 11.2063 10.2767 12.2984 10.2767C14.0281 10.2767 15.3406 9.25014 15.7344 7.73608C15.7109 7.86733 15.7016 8.00795 15.7016 8.15795C15.7016 9.28764 16.6906 10.2673 18.5422 10.2673C19.7891 10.2673 20.6891 10.0001 21.4438 9.07202C21.4438 9.38139 21.4578 9.69545 21.4953 10.0189H22.8922C22.8594 9.63451 22.8453 9.19858 22.8453 8.76264V5.68764C22.8453 5.2517 22.7656 4.88139 22.6203 4.57202L25.5031 10.0142L24.1672 12.5501H25.85L30.5 3.41889H28.9063ZM11.9234 9.24545C10.5359 9.24545 9.57032 8.23764 9.57032 6.72358C9.57032 5.20483 10.5359 4.2017 11.9234 4.2017C13.3203 4.2017 14.2766 5.20483 14.2766 6.72358C14.2766 8.23764 13.3203 9.24545 11.9234 9.24545ZM21.3406 7.02826C21.3406 8.43451 20.5016 9.29702 18.9219 9.29702C17.7453 9.29702 17.2813 8.66889 17.2813 8.08764C17.2813 7.19233 18.1297 6.94389 19.4938 6.9017C20.1078 6.87826 20.7875 6.87358 21.3406 6.87358V7.02826ZM2.03282 7.10327H8.07032V6.70483C8.07032 4.28139 6.51876 3.17045 4.39532 3.17045C1.73282 3.17045 0.5047 4.6142 0.5047 6.80795C0.5047 8.80014 1.69064 10.2767 4.37189 10.2767C5.84376 10.2767 7.55939 9.72827 7.85939 8.11577H6.30783C5.74533 9.79389 2.19689 9.83608 2.03282 7.10327ZM6.48595 6.10014H2.06095C2.38439 3.44702 6.37814 3.53608 6.48595 6.10014Z" fill="currentColor"/></svg>',
            self::WORDPRESS   => '<svg width="24" height="25" viewBox="0 0 24 25" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M2.55887 8.4767L7.31669 21.5079C3.98856 19.8954 1.69637 16.4829 1.69637 12.5361C1.69637 11.0876 2.00575 9.71888 2.55887 8.4767ZM18.3979 12.0345C18.3979 10.8017 17.9573 9.94857 17.5776 9.28295C17.0714 8.46263 16.5979 7.7642 16.5979 6.94388C16.5979 6.02513 17.2917 5.17201 18.2714 5.17201C18.3136 5.17201 18.3558 5.1767 18.4026 5.18138C16.6261 3.55482 14.2636 2.56107 11.6667 2.56107C8.18387 2.56107 5.11825 4.34701 3.33231 7.05638C3.56669 7.06576 3.787 7.07045 3.9745 7.07045C5.01512 7.07045 6.63231 6.94388 6.63231 6.94388C7.17137 6.91107 7.23231 7.70326 6.69794 7.7642C6.69794 7.7642 6.15887 7.82513 5.55887 7.85795L9.19169 18.6579L11.3761 12.1142L9.8245 7.85795C9.28544 7.82513 8.77919 7.7642 8.77919 7.7642C8.24012 7.73138 8.30575 6.91107 8.84012 6.94388C8.84012 6.94388 10.4854 7.07045 11.4651 7.07045C12.5057 7.07045 14.1229 6.94388 14.1229 6.94388C14.662 6.91107 14.7229 7.70326 14.1886 7.7642C14.1886 7.7642 13.6495 7.82513 13.0495 7.85795L16.6542 18.5783L17.6479 15.2548C18.0698 13.8767 18.3979 12.8876 18.3979 12.0345ZM11.8401 13.4079L8.8495 22.1033C9.74481 22.3658 10.687 22.5111 11.6667 22.5111C12.8292 22.5111 13.9401 22.3095 14.9761 21.9439C14.9479 21.9017 14.9245 21.8548 14.9058 21.8079L11.8401 13.4079ZM20.4183 7.75013C20.4604 8.06888 20.4839 8.40638 20.4839 8.7767C20.4839 9.7892 20.2964 10.9236 19.7245 12.3486L16.6776 21.1564C19.6448 19.4267 21.637 16.2158 21.637 12.5361C21.637 10.8017 21.1964 9.17045 20.4183 7.75013ZM23.2917 12.5361C23.2917 18.9486 18.0745 24.1611 11.6667 24.1611C5.25419 24.1611 0.041687 18.9439 0.041687 12.5361C0.041687 6.12357 5.25419 0.911072 11.6667 0.911072C18.0745 0.911072 23.2917 6.12357 23.2917 12.5361ZM22.7573 12.5361C22.7573 6.41888 17.7792 1.44545 11.6667 1.44545C5.5495 1.44545 0.576062 6.41888 0.576062 12.5361C0.576062 18.6533 5.55419 23.6267 11.6667 23.6267C17.7839 23.6267 22.7573 18.6533 22.7573 12.5361Z" fill="currentColor"/></svg>',
            self::GOOGLE_PLAY => '<svg width="22" height="25" viewBox="0 0 22 25" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M14.0818 11.5189L3.73647 1.14545L16.899 8.7017L14.0818 11.5189ZM1.03647 0.536072C0.4271 0.854822 0.0192871 1.43607 0.0192871 2.19076V22.8767C0.0192871 23.6314 0.4271 24.2126 1.03647 24.5314L13.0646 12.5314L1.03647 0.536072ZM20.9677 11.1111L18.2068 9.51263L15.1271 12.5361L18.2068 15.5595L21.024 13.9611C21.8677 13.2908 21.8677 11.7814 20.9677 11.1111ZM3.73647 23.9267L16.899 16.3704L14.0818 13.5533L3.73647 23.9267Z" fill="currentColor"/></svg>',
            self::APP_STORE   => '<svg width="24" height="25" viewBox="0 0 24 25" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M11.9954 6.20326L12.4219 5.46732C12.6844 5.00795 13.2704 4.85326 13.7297 5.11576C14.1891 5.37826 14.3438 5.9642 14.0813 6.42357L9.97975 13.5251H12.9469C13.9079 13.5251 14.4469 14.6548 14.0297 15.4376H5.33444C4.80475 15.4376 4.37819 15.0111 4.37819 14.4814C4.37819 13.9517 4.80475 13.5251 5.33444 13.5251H7.77194L10.8938 8.11576L9.91881 6.42357C9.65631 5.9642 9.811 5.38295 10.2704 5.11576C10.7297 4.85326 11.311 5.00795 11.5782 5.46732L11.9954 6.20326ZM8.30631 16.422L7.38756 18.0158C7.12506 18.4751 6.53912 18.6298 6.07975 18.3673C5.62037 18.1048 5.46569 17.5189 5.72819 17.0595L6.41256 15.8783C7.18131 15.6392 7.80944 15.822 8.30631 16.422ZM16.2235 13.5298H18.7126C19.2422 13.5298 19.6688 13.9564 19.6688 14.4861C19.6688 15.0158 19.2422 15.4423 18.7126 15.4423H17.3298L18.2626 17.0595C18.5251 17.5189 18.3704 18.1001 17.911 18.3673C17.4516 18.6298 16.8704 18.4751 16.6032 18.0158C15.0329 15.2923 13.8516 13.2533 13.0688 11.8939C12.2672 10.5111 12.8391 9.12357 13.4063 8.65482C14.0344 9.73295 14.9719 11.3595 16.2235 13.5298ZM12.0001 0.911072C5.57819 0.911072 0.375061 6.1142 0.375061 12.5361C0.375061 18.9579 5.57819 24.1611 12.0001 24.1611C18.4219 24.1611 23.6251 18.9579 23.6251 12.5361C23.6251 6.1142 18.4219 0.911072 12.0001 0.911072ZM22.1251 12.5361C22.1251 18.1001 17.6204 22.6611 12.0001 22.6611C6.436 22.6611 1.87506 18.1564 1.87506 12.5361C1.87506 6.97201 6.37975 2.41107 12.0001 2.41107C17.5641 2.41107 22.1251 6.91576 22.1251 12.5361Z" fill="currentColor"/></svg>',
        };
    }

    public function url()
    {
        return match ($this) {
            self::AMAZON      => 'https://www.amazon.com/',
            self::SHOPIFY     => 'https://www.shopify.com/',
            self::ETSY        => 'https://www.etsy.com/',
            self::EBAY        => 'https://www.ebay.com/',
            self::WORDPRESS   => 'https://wordpress.com/',
            self::GOOGLE_PLAY => 'https://play.google.com/',
            self::APP_STORE   => 'https://www.apple.com/hk/en/app-store/',
        };
    }
}
